package com.bxm.localnews.msg.facade.fallback;

import com.bxm.localnews.msg.facade.UserFacadeService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UserFallbackFactory implements FallbackFactory<UserFacadeService> {

    @Override
    public UserFacadeService create(Throwable throwable) {
        return userId -> ResponseEntity.badRequest().build();
    }
}
