package com.bxm.localnews.msg.integration;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.msg.facade.AppVersionFeignService;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/2/28 17:50
 * @desc
 */
@Service
public class AppVersionIntegrationService {

    @Autowired
    private AppVersionFeignService appVersionFeignService;

    public Boolean getPublishState(BasicParam param) {
        return appVersionFeignService.getPublishState(param).getBody();
    }

    public Boolean inWhiteList(String phone) {
        return appVersionFeignService.inWhiteList(phone).getBody();
    }

    public boolean beforeImVersion(BasicParam param) {
        return StringUtils.compareVersion(param.getCurVer(), "2.6.0") < 0;
    }
}

