package com.bxm.localnews.msg.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.msg.facade.UserFacadeService;
import com.bxm.localnews.msg.vo.UserInfoBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UserIntegrationService {

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final UserFacadeService userFacadeService;

    private KeyGenerator userInfoKey = DefaultKeyGenerator.build("user", "cache", "userInfo");

    @Autowired
    public UserIntegrationService(RedisHashMapAdapter redisHashMapAdapter,
                                  UserFacadeService userFacadeService) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userFacadeService = userFacadeService;
    }

    /**
     * 获取用户信息
     * 尝试从缓存获取，如果获取为空，尝试调用用户服务接口
     * @param userId 用户ID
     * @return 用户信息
     */
    public UserInfoBean getUserInfo(Long userId) {
        String cache = redisHashMapAdapter.get(userInfoKey, userId.toString(), String.class);
        if (null != cache) {
            return JSON.parseObject(cache, UserInfoBean.class);
        }

        ResponseEntity<UserInfoBean> response = userFacadeService.getUserInfo(userId);
        if (response.hasBody()) {
            return response.getBody();
        }
        return null;
    }
}
