package com.bxm.localnews.msg.facade;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.msg.facade.fallback.AppVersionFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews", fallbackFactory = AppVersionFallbackFactory.class, primary = false)
public interface AppVersionFeignService {

    @GetMapping("/facade/app/version/state")
    ResponseEntity<Boolean> getPublishState(@RequestBody BasicParam basicParam);

    /**
     * 获取手机号码是否为白名单
     *
     * @param phone 手机号码
     * @return true表示在白名单中
     * @deprecated 不再使用
     */
    @Deprecated
    @GetMapping("/facade/app/version/white")
    ResponseEntity<Boolean> inWhiteList(@RequestParam("phone") String phone);
}

