package com.bxm.localnews.msg.facade.fallback;

import com.bxm.localnews.msg.facade.AdvertFeignService;
import com.google.common.collect.Lists;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/4/9 10:44
 * @desc
 */
@Component
@Slf4j
public class AdvertFallbackFactory implements FallbackFactory<AdvertFeignService> {

    @Override
    public AdvertFeignService create(Throwable throwable) {
        return (type, areaCode, userId) -> {
            log.error(throwable.getMessage(), throwable);
            return ResponseEntity.ok(Lists.newArrayList());
        };
    }
}
