package com.bxm.localnews.msg.integration;

import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.msg.facade.BizLogFeignService;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
@Slf4j
public class BizLogIntegrationService {

    @Resource
    private BizLogFeignService bizLogFeignService;


    /**
     * 数据埋点上报
     *
     * @param param 埋点参数
     */
    public void point(PointReportParam param) {
        Preconditions.checkArgument(null != param);
        bizLogFeignService.point(param);
    }
}
