package com.bxm.localnews.msg.dto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 未读互动消息视图类
 *
 * @author wzy
 * @version 1.0
 * @date 2020/9/18 4:33 下午
 */
@Data
@ApiModel("未读互动消息视图类")
public class InteractMessageDTO {

    @ApiModelProperty("未读消息数量")
    private Integer messageCount;

    @ApiModelProperty("最新评论或点赞的头像url")
    private String headImageUrl;

    @ApiModelProperty("最新消息的类型：0评论，1点赞")
    private Byte latestMessageType;

    @ApiModelProperty("路由跳转协议：跳转评论tab，还是点赞tab")
    private String jumpUrl;
}