package com.bxm.localnews.msg.dto;

import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "消息类型")
@Data
public class MessageType {

    /**
     * @see MessageTypeEnum
     */
    @ApiModelProperty("消息类型：INTERACTION(互动消息)、" +
            "SYSTEM(系统通知)、" +
            "NEWS(热闻)、" +
            "BALANCE(余额)、" +
            "COMMENT(评论)、" +
            "LIKE(点赞)、" +
            "SHARE(分享)、" +
            "INVITE(邀请)、" +
            "LIKE_AND_COMMENT(点赞和评论)、" +
            "MERCHANT_WELFARE(福利号)、" +
            "AT_ME(@我)、" +
            "TASK(任务完成通知、" +
            "ADD_FUNS(新增粉丝消息))")
    private String messageType;

    @ApiModelProperty(value = "类型名称")
    private String title;

    @ApiModelProperty("类型图标")
    private String img;

    @ApiModelProperty("当前类型的最后一条消息")
    private String description;

    @ApiModelProperty("最后一条的消息时间，格式：根据需求返回的时间字符串 例：YYYY-MM-dd")
    private String lastTime;

    @ApiModelProperty("未读消息数量 小于99直接显示，大于显示：99+，需要客户端自己控制显示")
    private Integer unreadNum;

    @ApiModelProperty("消息的创建时间")
    private Date sourceLastTime;

    @ApiModelProperty("最后条未读互动消息的头像")
    private String headIcon;
}
