package com.bxm.localnews.msg.dto;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(description = "【3.12.0】消息中心类型列表")
@Data
public class MessageTypeV3DTO {

    @ApiModelProperty("广告列表")
    private List<AdvertDTO> advertDTOS = Lists.newArrayList();

    @ApiModelProperty("消息类型列表")
    private List<MessageType> messageTypes = Lists.newArrayList();

    @ApiModelProperty("【3.12.0】顶部消息列表（评论点赞消息类型、新增粉丝消息类型等等）")
    private List<MessageType> topMessageTypes = Lists.newArrayList();
}
