package com.bxm.localnews.msg.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "推送消息统计")
@Data
public class PushMessageStatistical {

    @ApiModelProperty(value = "消息id")
    private Long id;

    @ApiModelProperty(value = "推送平台")
    private String pushPlatform;

    @ApiModelProperty(value = "平台推送量")
    private Long userTotal = 0L;

    @ApiModelProperty(value = "推送成功人数")
    private Long pushSuccess = 0L;

    @ApiModelProperty(value = "推送失败人数")
    private Long pushFail = 0L;

    @ApiModelProperty(value = "打开人数")
    private Long openTotal = 0L;

    @ApiModelProperty(value = "ios打开人数")
    private Long iosOpenNum = 0L;

    @ApiModelProperty(value = "android打开人数")
    private Long androidOpenNum = 0L;

    @ApiModelProperty(value = "打开率")
    private Double openRate = 0d;

    public void addPushSuccess(int num) {
        this.pushSuccess += num;
    }

    public void addOpenTotal(int num) {
        this.openTotal += num;
    }

    public void addPushFail(int num) {
        this.pushFail += num;
    }

    public void addUserTotal(int success, int fail) {
        this.userTotal += success;
        this.userTotal += fail;
    }
}
