package com.bxm.localnews.msg.param;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.PageParam;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "消息参数")
@Data
public class MessageListParam extends PageParam implements IUserIdSharding {
    private static final long serialVersionUID = -381064449181017004L;
    @NotNull
    private Long userId;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("消息类型：INTERACTION(互动消息)、" +
            "SYSTEM(系统通知)、" +
            "NEWS(热闻)、" +
            "BALANCE(余额)、" +
            "COMMENT(评论)、" +
            "LIKE(点赞)、" +
            "SHARE(分享)、" +
            "INVITE(邀请)、" +
            "LIKE_AND_COMMENT(点赞和评论)、" +
            "MERCHANT_WELFARE(福利号)、" +
            "TASK(任务完成通知、" +
            "ADD_FUNS(新增粉丝消息))" +
            "AT_ME(@我 3.12.0新增)、")
    private String messageType;

    @ApiModelProperty(value = "消息类型参数列表", hidden = true)
    private List<String> msgTypeList = Lists.newArrayList();
}
