package com.bxm.localnews.msg.vo;

import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "用户通知消息")
public class UserMessageBean extends BaseBean {

    @ApiModelProperty("消息ID")
    private Long id;

    @ApiModelProperty(hidden = true)
    private Long userId;

    @ApiModelProperty("消息图标")
    private String icon;

    @ApiModelProperty("消息标题")
    private String title;

    @ApiModelProperty("消息内容")
    private String content;

    @ApiModelProperty(hidden = true)
    private Byte status;

    /**
     * 该字段同{@link PushMessageEnum} 类型保持一致
     * 用作区分消息的具体类型（改类型与消息中心的消息类型是有区别的
     * 消息中心的类型是一个汇总，例如消息中心的系统消息里面，可能包含了消息中 0 系统消息、 1 通知消息 等等
     * 当然也有一些消息只包含一个具体的类型，如107 @我的）
     */
    @ApiModelProperty("消息类型 " +
            "0 系统消息  " +
            "1 通知消息," +
            "9 新闻，" +
            "11 参加活动成功，" +
            "12 活动开奖，" +
            "13 活动中奖，" +
            "14 奖品过期，" +
            "15 任务完成（日常/新手）" +
            "107 @我的评论 3.12.0新增")
    private String msgType;

    @ApiModelProperty("发送时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty("消息状态 0：未读  1：已读  2：删除")
    private Byte readStatus;

    @ApiModelProperty(hidden = true)
    private Integer sendType;

    @ApiModelProperty(hidden = true)
    private Integer sendState;

    @ApiModelProperty("跳转地址")
    private String linkUrl;

    @ApiModelProperty("跳转参数")
    private String linkParam;

    @ApiModelProperty("显示时间")
    private String lastTime;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("事件")
    private String action;

    @ApiModelProperty("附加缩略图")
    private String extendUrl;

    @ApiModelProperty("附加内容")
    private String extendContent;

    @ApiModelProperty("是否显示消息详情，true表示显示，false表示不显示")
    private Boolean hasDetail;

    @ApiModelProperty("互动类型 评论ID")
    private Long replyId;

    @ApiModelProperty("【3.12.0】评论是否有图片")
    private Boolean hasImg;

    public UserMessageBean() {
    }

    public UserMessageBean(Long userId, Byte status) {
        this.userId = userId;
        this.status = status;
    }

    public UserMessageBean(Long userId, String title, String content, String msgType) {
        this.userId = userId;
        this.title = title;
        this.content = content;
        this.msgType = msgType;
    }

    public UserMessageBean(Long userId, String icon, String title, String content, String msgType) {
        this.userId = userId;
        this.icon = icon;
        this.title = title;
        this.content = content;
        this.msgType = msgType;
    }
}
