package com.bxm.localnews.msg.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel(description = "消息类型")
@Data
public class MessageType {

    @ApiModelProperty("消息类型")
    private String messageType;

    @ApiModelProperty(value = "类型名称")
    private String title;

    @ApiModelProperty("类型图标")
    private String img;

    @ApiModelProperty("当前类型的最后一条消息")
    private String description;

    @ApiModelProperty("最后一条的消息时间，格式：根据需求返回的时间字符串 例：YYYY-MM-dd")
    private String lastTime;

    @ApiModelProperty("未读消息数量 小于99直接显示，大于显示：99+，需要客户端自己控制显示")
    private Integer unreadNum;

    @ApiModelProperty("消息的创建时间")
    private Date sourceLastTime;
}
