package com.bxm.localnews.msg.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 消息推送记录表
 */
@Data
public class MsgGroupPushBean implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 推送标题
     */
    private String title;

    /**
     * 推送内容
     */
    private String content;

    /**
     * 涉及用户总数
     */
    private Integer userTotal;

    /**
     * 推送区域范围，使用逗号分隔
     */
    private String areaScope;

    /**
     * 实际推送时间
     */
    private Date pushTime;

    /**
     * 推送状态（0:待确认、1:待推送、2：已推送）
     */
    private Byte status;

    /**
     * 推送方式：透传、通知（根据枚举取值）
     */
    private String pushType;

    /**
     * 推送平台，使用逗号分隔，取值详见枚举。为空表示全量推送
     */
    private String pushPlatform;

    /**
     * 推送目标：1、用户，2：区域，3全量
     */
    private Byte pushTarget;

    /**
     * 用户属性，1无限制 2VIP
     */
    private Byte userProperty;

    /**
     * 消息有效时长（单位：小时）
     */
    private Integer periodTime;

    /**
     * 通知是否有振动
     */
    private Byte isVibrate;

    /**
     * 是否定时
     */
    private Byte isTiming;

    /**
     * 是否有提示音(0：否，1：是)
     */
    private Byte isMute;

    /**
     * 提示音类型（固定值，取值见枚举）
     */
    private String soundType;

    /**
     * 是否浮动通知(0：否，1：是)
     */
    private Byte isFloatNotify;

    /**
     * 展示文本
     */
    private String notifyText;

    /**
     * 展开图片地址
     */
    private String notifyImgUrl;

    /**
     * 展开式通知，取值详见枚举
     */
    private String unfoldType;

    /**
     * 推送后的动作，1：启动应用，2：下载应用，3：打开新闻，4：打开资讯活动，5：打开指定网页
     */
    private Byte actionType;

    /**
     * 推送需要的参数（json格式）
     */
    private String actionParams;

    /**
     * 创建人ID（运营账号ID）
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后变更时间
     */
    private Date modifyTime;

    /**
     * 多个用户试用逗号分隔
     */
    private String targetUserid;

    /**
     * 额外扩展参数，由运营后台服务、用户服务协定，用于圈定用户信息
     */
    private String extendParams;

    private static final long serialVersionUID = 1L;
}