package com.bxm.localnews.msg.vo;

import lombok.Builder;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 群推消息统计
 */
@Data
@Builder
@ToString
public class MsgGroupPushCounterBean implements Serializable {

    @Tolerate
    public MsgGroupPushCounterBean() {
    }

    /**
     * 主键
     */
    private Long id;

    /**
     * 群推消息ID
     */
    private Long groupMsgId;

    /**
     * 推送类型
     */
    private Byte pushType;

    /**
     * 推送成功数量
     */
    private Integer success;

    /**
     * 推送失败数量
     */
    private Integer fail;

    /**
     * 触达用户后的打开数量
     */
    private Integer callback;

    /**
     * 创建时间
     */
    private Date createTime;

    private static final long serialVersionUID = 1L;
}