/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.push.impl;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.push.PushResponseCallback;
import com.bxm.localnews.msg.push.Response;
import com.bxm.localnews.msg.service.MessageGroupCounterService;
import com.bxm.localnews.msg.service.MessageGroupService;
import com.bxm.localnews.msg.service.UserTokenService;
import com.bxm.localnews.msg.vo.MsgGroupPushCounterBean;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultPushResponseCallback
implements PushResponseCallback {
    private static final Logger log = LoggerFactory.getLogger(DefaultPushResponseCallback.class);
    @Resource
    private MessageGroupService messageGroupService;
    @Resource
    private UserTokenService userTokenService;
    @Resource
    private MessageGroupCounterService messageGroupCounterService;

    @Override
    public void apply(PushMessage message, MsgUserTokenBean userToken, Response response) {
        if (log.isDebugEnabled()) {
            log.debug("\u6536\u5230\u63a8\u9001\u56de\u8c03\u4fe1\u606f\uff0c\u6d88\u606fID\uff1a{},token:{},response:{}", new Object[]{message.getMsgId(), userToken, response});
        }
        if (response.isTokenExpired()) {
            this.userTokenService.removeToken(userToken);
        }
        if (response.isSuccess()) {
            this.success(message, userToken);
        } else {
            this.failed(message, userToken, response);
        }
    }

    private void success(PushMessage message, MsgUserTokenBean userToken) {
        if (this.messageGroupService.isGroupMsg(message.getMsgId())) {
            this.messageGroupCounterService.addCounter(MsgGroupPushCounterBean.builder().groupMsgId(message.getMsgId()).success(Integer.valueOf(1)).pushType(userToken.getType()).build());
        }
    }

    private void failed(PushMessage message, MsgUserTokenBean userToken, Response response) {
        if (this.messageGroupService.isGroupMsg(message.getMsgId())) {
            this.messageGroupCounterService.addCounter(MsgGroupPushCounterBean.builder().groupMsgId(message.getMsgId()).fail(Integer.valueOf(1)).pushType(userToken.getType()).build());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{},token : {}", (Object)response.getMessage(), (Object)userToken.getToken());
        }
    }
}

