/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.constant.SendTypeEunm;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.PushMessageStatusEnum;
import com.bxm.localnews.msg.dto.AdminPushMessageDTO;
import com.bxm.localnews.msg.dto.AreaCode;
import com.bxm.localnews.msg.dto.LocationDTO;
import com.bxm.localnews.msg.dto.PushMessageStatistical;
import com.bxm.localnews.msg.integration.LocationIntegrationService;
import com.bxm.localnews.msg.param.PushMessageParam;
import com.bxm.localnews.msg.push.PushExecutor;
import com.bxm.localnews.msg.service.AdminPushMessageService;
import com.bxm.localnews.msg.service.MessageGroupCounterService;
import com.bxm.localnews.msg.service.MessageGroupService;
import com.bxm.localnews.msg.vo.AdminPushMessage;
import com.bxm.localnews.msg.vo.MsgGroupPushBean;
import com.bxm.localnews.msg.vo.MsgGroupPushCounterBean;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class AdminPushMessageServiceImpl
implements AdminPushMessageService {
    private final MessageGroupService messageGroupService;
    private final LocationIntegrationService locationIntegrationService;
    private final PushExecutor pushExecutor;
    private final MessageGroupCounterService messageGroupCounterService;

    @Autowired
    public AdminPushMessageServiceImpl(MessageGroupService messageGroupService, LocationIntegrationService locationIntegrationService, PushExecutor pushExecutor, MessageGroupCounterService messageGroupCounterService) {
        this.messageGroupService = messageGroupService;
        this.locationIntegrationService = locationIntegrationService;
        this.pushExecutor = pushExecutor;
        this.messageGroupCounterService = messageGroupCounterService;
    }

    @Override
    public PageWarper<AdminPushMessageDTO> queryPushMessageList(PushMessageParam pushMessageParam) {
        List<MsgGroupPushBean> groupMessageByPage = this.messageGroupService.getGroupMessageByPage(pushMessageParam);
        List messageList = groupMessageByPage.stream().map(this::covertPushMessage).collect(Collectors.toList());
        PageWarper pageWarper = new PageWarper(groupMessageByPage);
        pageWarper.setList(messageList);
        return pageWarper;
    }

    private AdminPushMessageDTO covertPushMessage(MsgGroupPushBean groupPushBean) {
        AdminPushMessageDTO pushMessage = new AdminPushMessageDTO();
        BeanUtils.copyProperties((Object)groupPushBean, (Object)pushMessage);
        pushMessage.setTiming(groupPushBean.getIsTiming());
        pushMessage.setFloatNotify(groupPushBean.getIsFloatNotify());
        pushMessage.setMute(groupPushBean.getIsMute());
        pushMessage.setVibrate(groupPushBean.getIsVibrate());
        pushMessage.setCreateUser(this.getAdminUserId().toString());
        if (StringUtils.isNotEmpty((CharSequence)pushMessage.getAreaScope())) {
            ArrayList areaCodes = Lists.newArrayList();
            for (String areaCode : Splitter.on((String)",").split((CharSequence)pushMessage.getAreaScope())) {
                LocationDTO areaInfo = this.locationIntegrationService.getLocationByGeocode(areaCode);
                if (null == areaInfo) continue;
                AreaCode area = new AreaCode();
                area.setAreaCode(areaInfo.getCode());
                area.setAreaName(areaInfo.getName());
                areaCodes.add(area);
            }
            pushMessage.setAreaCodeList((List)areaCodes);
        }
        return pushMessage;
    }

    private MsgGroupPushBean adapter(AdminPushMessage message) {
        MsgGroupPushBean groupPushBean = new MsgGroupPushBean();
        BeanUtils.copyProperties((Object)message, (Object)groupPushBean);
        groupPushBean.setIsFloatNotify(message.getFloatNotify());
        groupPushBean.setIsMute(message.getMute());
        groupPushBean.setIsTiming(message.getTiming());
        groupPushBean.setIsVibrate(message.getVibrate());
        groupPushBean.setCreateUserId(this.getAdminUserId());
        return groupPushBean;
    }

    private Long getAdminUserId() {
        ServletRequestAttributes servletRequestAttributes;
        HttpServletRequest request;
        String currentUserId;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes && NumberUtils.isDigits((String)(currentUserId = (request = (servletRequestAttributes = (ServletRequestAttributes)requestAttributes).getRequest()).getHeader("currentUserId")))) {
            return Long.valueOf(currentUserId);
        }
        return 0L;
    }

    @Override
    public AdminPushMessage getDetail(Long id) {
        MsgGroupPushBean groupPushBean = this.messageGroupService.get(id);
        return this.covertPushMessage(groupPushBean);
    }

    @Override
    public Message saveOrUpdatePushMessage(AdminPushMessage adminPushMessage) {
        Message message = Message.build();
        if (!(message = this.checkValidMessage(adminPushMessage, message)).isSuccess()) {
            return message;
        }
        MsgGroupPushBean groupBean = this.adapter(adminPushMessage);
        return this.messageGroupService.save(groupBean);
    }

    private Message checkValidMessage(AdminPushMessage adminPushMessage, Message message) {
        Date now = new Date();
        if (SendTypeEunm.SEND_TIMING.getType().equals(adminPushMessage.getTiming() + "") && adminPushMessage.getPushTime().getTime() < now.getTime()) {
            return message.setSuccess(false).setMessage("\u63a8\u9001\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        return message;
    }

    @Override
    public Message updateStatusPushMessage(Long id, Byte status) {
        PushMessageStatusEnum statusEnum = PushMessageStatusEnum.getByStatus(status);
        return this.messageGroupService.changeStatus(id, statusEnum);
    }

    @Override
    public Message testPushMessage(Long id, Long userId) {
        PushMessage pushMessage = this.messageGroupService.loadCache(id);
        if (null == pushMessage) {
            return Message.build((boolean)false, (String)"\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        pushMessage.assign(userId);
        pushMessage.setPersistence(false);
        this.pushExecutor.push(pushMessage);
        return Message.build();
    }

    @Override
    public Message testPushMessage(Long id, String userIds) {
        String[] userIdData = StringUtils.split((String)userIds, (String)",");
        List userIdList = Stream.of(userIdData).map(Long::new).collect(Collectors.toList());
        for (Long userId : userIdList) {
            this.testPushMessage(id, userId);
        }
        return Message.build();
    }

    @Override
    public Message immediatelyPushMessage(Long id) {
        Message message = Message.build();
        MsgGroupPushBean groupMessage = this.messageGroupService.get(id);
        if (groupMessage == null) {
            return message.setSuccess(false).setMessage("\u8be5\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        if (PushMessageStatusEnum.HAS_BEEN_SEND.getType().equals(groupMessage.getStatus())) {
            return message.setSuccess(false).setMessage("\u8be5\u6d88\u606f\u5df2\u63a8\u9001");
        }
        if (PushMessageStatusEnum.BEING_SEND.getType().equals(groupMessage.getStatus())) {
            return message.setSuccess(false).setMessage("\u8be5\u6d88\u606f\u6b63\u5728\u63a8\u9001\u4e2d\uff0c\u8bf7\u5237\u65b0\u540e\u67e5\u770b");
        }
        if (SendTypeEunm.SEND_NOW.getType().equals(String.valueOf(groupMessage.getIsTiming()))) {
            groupMessage.setPushTime(new Date());
            groupMessage.setStatus(PushMessageStatusEnum.BEING_SEND.getType());
            this.messageGroupService.pushNow(groupMessage);
        }
        if (SendTypeEunm.SEND_TIMING.getType().equals(String.valueOf(groupMessage.getIsTiming()))) {
            this.messageGroupService.createTimer(groupMessage);
            this.messageGroupService.changeStatus(id, PushMessageStatusEnum.STAY_SEND);
        }
        return Message.build();
    }

    @Override
    public Collection<PushMessageStatistical> getStatistical(Long id) {
        MsgGroupPushBean pushMessage = this.messageGroupService.get(id);
        List<MsgGroupPushCounterBean> messageCounterList = this.messageGroupCounterService.getMessageCounter(id);
        HashMap tempMap = Maps.newHashMap();
        for (MsgGroupPushCounterBean counter : messageCounterList) {
            PlatformTypeEnum platform = PlatformTypeEnum.getByCode((byte)counter.getPushType());
            PushMessageStatistical statistical = (PushMessageStatistical)tempMap.get(platform.getLabel());
            if (statistical == null) {
                statistical = new PushMessageStatistical();
                statistical.setPushPlatform(platform.getLabel());
            }
            statistical.addOpenTotal(counter.getCallback().intValue());
            statistical.addPushSuccess(counter.getSuccess().intValue());
            statistical.addPushFail(counter.getFail().intValue());
            statistical.addUserTotal(counter.getSuccess().intValue(), counter.getFail().intValue());
            tempMap.put(platform.getLabel(), statistical);
        }
        if (tempMap.size() == 0) {
            return this.buildEmptyResult();
        }
        ArrayList finalResult = Lists.newArrayList();
        finalResult.addAll(tempMap.values());
        finalResult.add(this.total(pushMessage, finalResult));
        long index = 1L;
        for (PushMessageStatistical statistical : finalResult) {
            statistical.setId(Long.valueOf(index++));
        }
        return finalResult;
    }

    private List<PushMessageStatistical> buildEmptyResult() {
        ArrayList emptyList = Lists.newArrayList();
        PlatformTypeEnum[] platforms = PlatformTypeEnum.values();
        long index = 1L;
        for (PlatformTypeEnum platform : platforms) {
            if (!platform.isApp()) continue;
            PushMessageStatistical pushMessageStatistical = new PushMessageStatistical();
            pushMessageStatistical.setId(Long.valueOf(index++));
            pushMessageStatistical.setPushPlatform(platform.getLabel());
            pushMessageStatistical.setOpenRate(Double.valueOf(0.0));
            pushMessageStatistical.setUserTotal(Long.valueOf(0L));
            pushMessageStatistical.setPushSuccess(Long.valueOf(0L));
            pushMessageStatistical.setOpenTotal(Long.valueOf(0L));
            emptyList.add(pushMessageStatistical);
        }
        return emptyList;
    }

    private PushMessageStatistical total(MsgGroupPushBean pushMessage, Collection<PushMessageStatistical> result) {
        PushMessageStatistical calcTotal = new PushMessageStatistical();
        calcTotal.setPushPlatform("ALL");
        Long openTotal = 0L;
        Long successTotal = 0L;
        Long failTotal = 0L;
        for (PushMessageStatistical pms : result) {
            failTotal = failTotal + pms.getPushFail();
            openTotal = openTotal + pms.getOpenTotal();
            successTotal = successTotal + pms.getPushSuccess();
        }
        calcTotal.setUserTotal(Long.valueOf(pushMessage.getUserTotal().intValue()));
        calcTotal.setOpenTotal(openTotal);
        calcTotal.setPushSuccess(successTotal);
        calcTotal.setPushFail(failTotal);
        if (calcTotal.getUserTotal() == 0L) {
            calcTotal.setOpenRate(Double.valueOf(0.0));
        } else if (successTotal == 0L) {
            calcTotal.setOpenRate(Double.valueOf(1.0));
        } else {
            calcTotal.setOpenRate(Double.valueOf((double)openTotal.longValue() / (double)successTotal.longValue()));
        }
        return calcTotal;
    }
}

