/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.strategy.impl;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.listener.PushMsgListener;
import com.bxm.localnews.msg.strategy.impl.AbstractPushDistributeStrategy;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonPushDistributeStrategy
extends AbstractPushDistributeStrategy {
    @Autowired
    private PushMsgListener pushMsgListener;
    @Autowired
    private AppPushProperties appPushProperties;

    @Override
    public PushReceiverRuleEnum support() {
        return PushReceiverRuleEnum.DEFAULT;
    }

    @Override
    public void send(PushMessage message) {
        PushReceiveScope pushReceiveScope = message.getPushReceiveScope();
        List userIds = pushReceiveScope.getUserIds();
        if (message.isStatistics()) {
            this.execPreprocess(message);
            this.splitTask(userIds, message.getMsgId(), 1, 1);
        } else {
            userIds.forEach(userId -> {
                message.assign(userId);
                if (this.appPushProperties.getDirectPush().booleanValue() && this.pushMsgListener.hasIdleTime()) {
                    this.pushMsgListener.handlerSingle(message);
                } else {
                    this.messageProvider.singlePush(message);
                }
            });
        }
    }
}

