package com.bxm.localnews.msg.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.time.LocalTime;

/**
 * app消息推送相关的配置属性
 *
 * @author liujia 2018/7/26 16:27
 */
@Component
@ConfigurationProperties(prefix = "message.app.push")
@Data
public class AppPushProperties {

    /**
     * 个推平台推送相关配置参数
     */
    private String id;

    private String secret;

    private String key;

    private String masterSecret;

    private String host;

    /**
     * 华为请求accessToken的地址
     */
    private String huaweiAccessTokenUrl;

    /**
     * 华为API请求地址
     */
    private String huaweiApiUrl;

    /**
     * 华为密钥
     */
    private String huaweiClientSecret;

    /**
     * 华为AppId
     */
    private String huaweiAppId;

    /**
     * android推送需要的app包名称
     */
    private String appPkgName;

    /**
     * 是否使用小米沙箱,true表示使用
     */
    private boolean miuiSandbox;

    /**
     * 小米推送的app id
     */
    private String miuiAppId;

    /**
     * 小米推送的app secret
     */
    private String miuiAppSecret;

    /**
     * 友盟推送是否是正式环境
     */
    private boolean umengProductionMode;

    /**
     * 友盟ios appkey
     */
    private String umengIosAppkey;

    /**
     * 友盟ios app密钥
     */
    private String umengIosAppSecrect;

    /**
     * 友盟安卓appkey
     */
    private String umengAndroidAppkey;

    /**
     * 友盟安卓app密钥
     */
    private String umengAndroidAppSecrect;

    /**
     * vivo推送平台appid
     */
    private int vivoAppId = 0;

    /**
     * vivo推送平台appkey
     */
    private String vivoAppKey;

    /**
     * vivo推送平台密钥
     */
    private String vivoAppSecret;

    /**
     * oppo推送平台相关配置参数
     */
    private String oppoAppId;

    private String oppoAppKey;

    private String oppoAppSecret;

    /**
     * 推送标题为空时的默认文案
     */
    private String defaulPushTitle = "你有一条新的消息";

    /**
     * 推送内容为空时的默认文案
     */
    private String defaultPushContent = "你有一条新的消息";

    /**
     * 消息分片数量值，推送消息的接受对象不止一个时，进行分片处理
     */
    private int bucketNum = 100;

    /**
     * 从用户服务获取推送用户数量的倍数（基于消息分片数量）
     */
    private int pullMultiple = 10;

    /**
     * 限制给用户发送推送消息的时间段-起始时间，在此之前不允许推送
     */
    private LocalTime startLimitTime = LocalTime.parse("07:00");

    /**
     * 限制给用户发送推送消息的时间段-截止时间，在此之后不允许推送
     */
    private LocalTime endLimitTime = LocalTime.parse("22:00");

    /**
     * 单体推送优先直接推送，不走消息队列
     */
    private Boolean directPush = true;
}
