package com.bxm.localnews.msg.platform;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.push.PushResponseCallback;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;

/**
 * 不同推送SDK平台的对接处理
 * 仅负责进行具体的推送功能，不负责处理具体的业务逻辑
 *
 * @author liujia
 */
public interface IPushPlatform {

    /**
     * 推送成功的通用结果
     */
    String SUCCESS = "ok";

    /**
     * 推送失败的通用结果
     */
    String FAILED = "failed";

    /**
     * 执行消息推送
     *
     * @param message   推送的消息实体
     * @param userToken 用户token，与推送相关的信息
     * @param callback  推送结果的回调处理
     */
    void push(PushMessage message, MsgUserTokenBean userToken, PushResponseCallback callback);

    /**
     * 推送平台类型
     *
     * @return 平台枚举
     */
    PlatformTypeEnum getType();
}
