package com.bxm.localnews.msg.platform.impl;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.domain.MessageMapper;
import com.bxm.localnews.msg.platform.IPushPlatform;
import com.bxm.localnews.msg.push.PushResponseCallback;
import com.bxm.localnews.msg.service.UserMessageService;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.bxm.newidea.component.uuid.SequenceCreater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;

/**
 * 抽象的推送平台类
 * 处理推送相关的共同内容
 *
 * @author liujia
 */
public abstract class AbstractPushPlatform implements IPushPlatform {

    Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private SequenceCreater sequenceCreater;

    @Autowired
    private UserMessageService userMessageService;

    @Autowired
    private MessageMapper messageMapper;

    @Resource
    protected AppPushProperties appPushProperties;

    @Override
    public void push(PushMessage message, MsgUserTokenBean userToken, PushResponseCallback callback) {

    }

    /**
     * 推送结果回调处理
     */
//    void successCallback(PushMessage message, MsgUserTokenBean userToken, String response) {
//    }
//
//    void callback(PushMessage message, List<UserDeviceBean> users, String response) {
//        new BatchHelper<PushUserMapper, UserDeviceBean>(PushUserMapper.class, users) {
//
//            @Override
//            protected int invoke(UserDeviceBean element) {
//                PushUserBean entity = new PushUserBean();
//                entity.setId(sequenceCreater.nextLongId());
//                entity.setChecked(0);
//                entity.setMessageId(message.getPayloadInfo().getMsgId());
//                entity.setPlatform(element.getPlatform());
//                entity.setUserId(element.getUserId());
//                entity.setPushTime(new Date());
//                entity.setPushResult(response);
//                entity.setRegisterClient(StringUtils.isEmpty(element.getRegisterClient()) ?
//                        "0" : element.getRegisterClient());
//                return mapper.insert(entity);
//            }
//        };
//
//        if (message.isPersistence()) {
//            doPersistence(message, users);
//        }
//    }

    /**
     * 持久化用户通知表
     */
//    private void doPersistence(PushMessage message, List<UserDeviceBean> users) {
//        logger.info("消息实例化到数据库[{}],用户数量：[{}]", message.getPayloadInfo().getMsgId(), users.size());
//
//        List<Message> messageList = Lists.newArrayList();
//        for (UserDeviceBean userDeviceBean : users) {
//            Message messageVo = new Message();
//            messageVo.setTitle(message.getTitle());
//            messageVo.setContent(message.getContent());
//            messageVo.setUserId(userDeviceBean.getUserId());
//            messageVo.setMsgType(String.valueOf(message.getPayloadInfo().getType()));
//            messageVo.setStatus((byte) 0);
//            messageVo.setLinkParam(JSON.toJSONString(message.getPayloadInfo()));
//            messageVo.setAddTime(new Date());
//            messageVo.setUpdateTime(new Date());
//            messageList.add(messageVo);
//        }
//
//        for (Message msg : messageList) {
//            userMessageService.addUnreadMsg(message, msg.getUserId());
//            messageMapper.insertSelective(msg);
//        }
//    }

}
