package com.bxm.localnews.msg.push;

import lombok.Data;
import lombok.ToString;

/**
 * 推送响应结果，包括正常、异常、用户不存在
 *
 * @author liujia
 * @date 2020-07-06 14:09
 **/
@Data
@ToString
public class Response {
    private Response() {
    }

    /**
     * 第三方推送的响应消息内容
     */
    private String message;

    /**
     * 是否推送成功，true表示成功
     */
    private boolean success;

    /**
     * true表示token已过期，如果过期，则需要移除用户的token
     */
    private boolean tokenExpired;

    /**
     * 推送成功的响应信息
     *
     * @param message 原始响应内容，可选
     * @return 响应对象
     */
    public static Response success(String message) {
        Response response = new Response();
        response.success = true;
        response.tokenExpired = false;
        response.message = message;
        return response;
    }

    /**
     * 推送成功的响应信息
     *
     * @return 响应对象
     */
    public static Response success() {
        Response response = new Response();
        response.success = true;
        response.tokenExpired = false;
        return response;
    }

    /**
     * 推送失败的响应信息
     *
     * @param message 原始响应内容
     * @return 响应对象
     */
    public static Response fail(String message) {
        Response response = new Response();
        response.success = false;
        response.tokenExpired = false;
        response.message = message;
        return response;
    }

    /**
     * 用户token过期的响应
     *
     * @param message 第三方响应内容
     * @return 响应对象
     */
    public static Response expire(String message) {
        Response response = new Response();
        response.success = false;
        response.tokenExpired = true;
        response.message = message;
        return response;
    }
}
