package com.bxm.localnews.msg.rule;

import com.bxm.localnews.mq.common.model.dto.PushMessage;

/**
 * 推送校验规则，判断是否允许进行内容推送
 * 后续拓展此规则，可以实现敏感词、用户限制、时间限制等
 *
 * @author liujia
 * @date 2020-07-05 11:19
 **/
public interface IPushRule {

    /**
     * 进行具体的校验
     *
     * @param message 待推送消息
     * @return true表示接受，false表示校验失败，将会取消此次推送
     */
    boolean accpect(PushMessage message);

    /**
     * 验证失败后是否允许将消息写入到消息中心
     *
     * @return true表示不执行最终推送，但是仍然写入到用户消息中心
     */
    default boolean write() {
        return false;
    }
}
