package com.bxm.localnews.msg.rule.impl;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.integration.UserIntegrationService;
import com.bxm.localnews.msg.rule.IPushRule;
import com.bxm.localnews.msg.vo.UserInfoBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 占位符替换处理，如果内容中存在占位符，则进行替换
 * 用在什么场景忘记了... 这里是对历史逻辑进行兼容
 *
 * @author liujia
 * @date 2020-07-13 15:23
 **/
@Component
public class PlaceHolderPushRule implements IPushRule {
    private static final String USER_NICKNAME = "{nickname}";

    private UserIntegrationService userIntegrationService;

    @Autowired
    public PlaceHolderPushRule(UserIntegrationService userIntegrationService) {
        this.userIntegrationService = userIntegrationService;
    }

    @Override
    public boolean accpect(PushMessage message) {
        if (havePlaceholder(message)) {
            processPlaceholders(message);
        }

        return true;
    }

    private boolean havePlaceholder(PushMessage message) {
        if (message.getContent() != null && message.getContent().contains(USER_NICKNAME)) {
            return true;
        } else if (message.getPayloadInfo() != null && message.getPayloadInfo().getContent() != null) {
            return message.getPayloadInfo().getContent().contains(USER_NICKNAME);
        }

        return false;
    }

    private void processPlaceholders(PushMessage message) {
        Long userId = message.getPushReceiveScope().getUserId();

        String nickname = loadUserName(userId);

        if (message.getContent() != null) {
            message.setContent(message.getContent().replace(USER_NICKNAME, nickname));
        }

        PushPayloadInfo pushPayloadInfo = message.getPayloadInfo();
        if (null != pushPayloadInfo && null != pushPayloadInfo.getContent()) {
            pushPayloadInfo.setContent(pushPayloadInfo.getContent().replace(USER_NICKNAME, nickname));
            message.setPayloadInfo(pushPayloadInfo);
        }
    }

    private String loadUserName(Long userId) {
        UserInfoBean userInfo = userIntegrationService.getUserInfo(userId);
        if (null == userInfo) {
            return "";
        }
        return userInfo.getNickname();
    }
}
