package com.bxm.localnews.msg.service;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.PushMessageStatusEnum;
import com.bxm.localnews.msg.param.PushMessageParam;
import com.bxm.localnews.msg.vo.MsgGroupPushBean;
import com.bxm.newidea.component.vo.Message;

import java.util.List;

/**
 * 群推消息（需要统计的消息）相关服务接口
 *
 * @author liujia
 * @date 2020-07-04 16:22
 **/
public interface MessageGroupService {

    /**
     * 运营后台填写的消息
     *
     * @param groupPushBean 消息内容
     * @return 保存结果
     */
    Message save(MsgGroupPushBean groupPushBean);

    /**
     * 立即执行推送
     *
     * @param groupPushBean 待推送的群推消息
     * @return 推送处理结果
     */
    Message pushNow(MsgGroupPushBean groupPushBean);

    /**
     * 获取自增的特殊消息ID
     * 运营后台发起的推送、需要进行统计的推送
     *
     * @return 消息ID
     */
    Long incrementMsgId();

    /**
     * 判断一条消息是否为群推消息
     *
     * @param msgId 消息ID
     * @return 如果消息ID符合定义的特殊消息ID规则，则认为是群推消息
     */
    boolean isGroupMsg(Long msgId);

    /**
     * 是否黑名单中的消息ID
     * 黑名单中的消息ID不进行发送
     *
     * @param msgId 消息ID
     * @return true表示在黑名单中
     */
    boolean isBlackMsgId(Long msgId);

    /**
     * 变更群推消息的状态
     *
     * @param msgId  消息ID
     * @param status 消息状态
     * @return 变更操作结果
     */
    Message changeStatus(Long msgId, PushMessageStatusEnum status);

    /**
     * 创建推送的定时任务
     *
     * @param entity 定时任务
     */
    void createTimer(MsgGroupPushBean entity);

    /**
     * 根据消息ID获取推送消息对象
     * 采用多级缓存，从本地 -> 缓存 -> 数据库获取数据
     *
     * @param msgId        消息ID
     * @param forceRefresh 是否强制刷新
     * @return 推送消息对象
     */
    PushMessage loadCache(Long msgId, boolean forceRefresh);

    /**
     * 根据消息ID获取推送信息详情
     *
     * @param msgId 消息ID
     * @return 消息详情
     */
    MsgGroupPushBean get(Long msgId);

    /**
     * 分页查询群退消息
     *
     * @param param 查询参数
     * @return 分页结果
     */
    List<MsgGroupPushBean> getGroupMessageByPage(PushMessageParam param);

    /**
     * 更新预计触达用户总数
     *
     * @param msgId     消息ID
     * @param userTotal 新增的用户总数
     */
    void addPushTotal(Long msgId, int userTotal);
}
