package com.bxm.localnews.msg.strategy;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;

/**
 * 消息分发策略，根据消息的优先级、使用场景，将消息分发到不同的通道，进行具体的推送处理
 *
 * @author liujia
 * @date 2020-07-04 11:23
 **/
public interface IPushDistributeStrategy {

    /**
     * 当前策略支持的接受范围
     *
     * @return 推送接收范围
     */
    PushReceiverRuleEnum support();

    /**
     * 将消息发送到消息队列
     *
     * @param message
     */
    void send(PushMessage message);
}
