package com.bxm.localnews.msg.strategy.impl;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.listener.PushMsgListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 常用的推送分发策略，用于处理已经明确指定了接受用户的情况
 * 用户之间的互动消息通过此策略进行处理
 *
 * @author liujia
 * @date 2020-07-04 12:20
 **/
@Component
public class CommonPushDistributeStrategy extends AbstractPushDistributeStrategy {

    @Autowired
    private PushMsgListener pushMsgListener;

    @Autowired
    private AppPushProperties appPushProperties;

    @Override
    public PushReceiverRuleEnum support() {
        return PushReceiverRuleEnum.DEFAULT;
    }

    @Override
    public void send(PushMessage message) {
        PushReceiveScope pushReceiveScope = message.getPushReceiveScope();
        List<Long> userIds = pushReceiveScope.getUserIds();

        // 如果需要统计，则走统计推送的批量推送通道
        if (message.isStatistics()) {
            execPreprocess(message);
            splitTask(userIds, message.getMsgId(), 1, 1);
        } else {
            // 正常推送则全部走单条推送的通道
            userIds.forEach(userId -> {
                message.assign(userId);

                // 当前服务处于空闲状态，不走消息队列，直接进行处理
                if (appPushProperties.getDirectPush() && pushMsgListener.hasIdleTime()) {
                    pushMsgListener.handlerSingle(message);
                } else {
                    messageProvider.singlePush(message);
                }
            });
        }
    }
}
