package com.bxm.localnews.msg.timer;

import com.bxm.localnews.msg.service.PushMsgSupplyService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 每半个小时推送用户的互动消息
 */
@Component
@Slf4j
public class InteractionPushMessageTask extends AbstractCronTask<String> {

    @Resource
    private PushMsgSupplyService pushMsgSupplyService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("开始定时推送互动消息");
        pushMsgSupplyService.pushInteraction();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "interactionPushMessageTask";
    }

    @Override
    public String cron() {
        return "0 0/30 8-22 * * ? *";
    }

    @Override
    public String description() {
        return "8点到22点给用户推送未读的互动消息";
    }

}
