/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.platform.impl;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.platform.impl.AbstractPushPlatform;
import com.bxm.localnews.msg.push.PushResponseCallback;
import com.bxm.localnews.msg.push.Response;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import com.huawei.push.javasdk.exception.HuaweiMesssagingException;
import com.huawei.push.javasdk.message.AndroidConfig;
import com.huawei.push.javasdk.message.AndroidNotification;
import com.huawei.push.javasdk.message.ClickAction;
import com.huawei.push.javasdk.message.Message;
import com.huawei.push.javasdk.message.Notification;
import com.huawei.push.javasdk.messaging.HuaweiApp;
import com.huawei.push.javasdk.messaging.HuaweiCredential;
import com.huawei.push.javasdk.messaging.HuaweiMessaging;
import com.huawei.push.javasdk.messaging.HuaweiOption;
import com.huawei.push.javasdk.messaging.SendResponse;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class HuaweiPushPlatform
extends AbstractPushPlatform
implements ApplicationRunner {
    @Resource
    private AppPushProperties appPushProperties;
    private HuaweiApp app;
    private static final int SUCCESS_CODE = 80000000;
    private static final int TOKEN_EXPIRED = 907122032;

    @Override
    public void push(PushMessage message, MsgUserTokenBean userToken, PushResponseCallback callback) {
        Notification notification = new Notification(message.getTitle(), message.getContent());
        ClickAction.Builder clickActionBuilder = ClickAction.builder().setType(Integer.valueOf(1));
        if (message.getActionType() != null) {
            String intent = "intent://" + this.appPushProperties.getAppPkgName() + "/push?message=" + message.getPayloadInfo().toJsonString() + "#Intent;scheme=route;launchFlags=0x20000;end";
            clickActionBuilder.setIntent(intent);
        }
        try {
            AndroidNotification androidNotification = AndroidNotification.builder().setTitle(message.getTitle()).setBody(message.getContent()).setClickAction(clickActionBuilder.build()).build();
            AndroidConfig androidConfig = AndroidConfig.builder().setNotification(androidNotification).setBiTag("Trump").build();
            Message huaweiMsg = Message.builder().setNotification(notification).setAndroidConfig(androidConfig).addAllToken((List)Lists.newArrayList((Object[])new String[]{userToken.getToken()})).build();
            SendResponse response = HuaweiMessaging.getInstance((HuaweiApp)this.app).send(huaweiMsg, false);
            if (80000000 == response.getCode()) {
                callback.apply(message, userToken, Response.success());
            } else if (907122032 == response.getCode()) {
                this.logger.info("\u7528\u6237\u7684\u534e\u4e3a\u63a8\u9001\u4ee4\u724c\u5df2\u5931\u6548\uff1a{}", (Object)userToken.getUserId());
                callback.apply(message, userToken, Response.expire(response.getMsg()));
            } else {
                this.logger.info("\u534e\u4e3a\u63a8\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{},\u6d88\u606f\u5185\u5bb9\uff1a{},\u63a8\u9001\u76ee\u6807\uff1a{}", new Object[]{response.getMsg(), message, userToken});
                callback.apply(message, userToken, Response.fail(response.getMsg()));
            }
        }
        catch (HuaweiMesssagingException e) {
            if (StringUtils.equals((CharSequence)"80300007", (CharSequence)e.getErrorCode())) {
                callback.apply(message, userToken, Response.expire(e.getMessage()));
            } else {
                callback.apply(message, userToken, Response.fail(e.getMessage()));
            }
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.HUAWEI;
    }

    public void run(ApplicationArguments args) {
        if (this.app == null) {
            HuaweiCredential credential = HuaweiCredential.builder().setAppId(this.appPushProperties.getHuaweiAppId()).setAppSecret(this.appPushProperties.getHuaweiClientSecret()).build();
            HuaweiOption option = HuaweiOption.builder().setCredential(credential).build();
            this.app = HuaweiApp.initializeApp((HuaweiOption)option);
            this.logger.debug("\u521d\u59cb\u5316\u534e\u4e3aApp");
        }
    }
}

