/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.platform.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.constant.PushFoldTypeEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.platform.impl.AbstractPushPlatform;
import com.bxm.localnews.msg.push.PushResponseCallback;
import com.bxm.localnews.msg.push.Response;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.google.common.collect.Lists;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.Media;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.Sender;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.parser.ParseException;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class MiuiPushPlatform
extends AbstractPushPlatform {
    @Override
    public void push(PushMessage message, MsgUserTokenBean userToken, PushResponseCallback callback) {
        Constants.useOfficial();
        Sender sender = new Sender(this.appPushProperties.getMiuiAppSecret());
        String title = message.getTitle();
        if (title.length() > 50) {
            title = title.substring(0, 47) + "...";
        } else if (StringUtils.isBlank((CharSequence)title)) {
            title = "\u63a8\u9001\u901a\u77e5";
        }
        int maxContentLength = 128;
        String description = message.getContent();
        if (Objects.nonNull(description) && description.length() > maxContentLength) {
            description = description.substring(0, maxContentLength);
        } else if (StringUtils.isBlank((CharSequence)description)) {
            description = title;
        }
        message.getPayloadInfo().getExtend().put("notifyImageUrl", message.getNotifyImageUrl());
        message.getPayloadInfo().getExtend().put("notifyText", message.getNotifyText());
        Message.Builder messageBuilder = new Message.Builder().title(title).description(description).timeToLive((long)message.getPeriodTime().intValue() * 3600000L).payload(JSON.toJSONString((Object)message.getPayloadInfo())).restrictedPackageName(this.appPushProperties.getAppPkgName());
        this.fillMessageBuilder(messageBuilder, message);
        if (PushFoldTypeEnum.IMAGE.equals((Object)message.getPushFoldType())) {
            File file = new File(message.getNotifyImageUrl());
            Media media = new Media(this.appPushProperties.getMiuiAppSecret());
            String picUrl = null;
            try {
                Result result = media.upload(file, false, true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u5c0f\u7c73\u4e0a\u4f20\u63a8\u9001\u6587\u4ef6\u8fd4\u56de\u7ed3\u679c\uff1a[{}], \u8fd4\u56de\u7684\u6570\u636e\uff1a[{}]", (Object)result.getErrorCode(), (Object)result.getData().toJSONString());
                }
                picUrl = URLDecoder.decode(result.getData("pic_url"), "UTF8");
            }
            catch (IOException e) {
                this.logger.error("\u5c0f\u7c73\u63a8\u9001\u56fe\u6587\u6d88\u606f\u4e0a\u4f20\u5927\u56fe\u9519\u8bef: \u56fe\u7247\u5730\u5740\uff1a[{}]", (Object)message.getNotifyImageUrl());
            }
            messageBuilder.extra(new Message.NotificationStyleBuilder().bigPictureStyle().bigPicUri(picUrl).build());
        }
        if (PushFoldTypeEnum.TEXT.equals((Object)message.getPushFoldType())) {
            messageBuilder.extra(new Message.NotificationStyleBuilder().bigTextStyle().build());
        }
        try {
            ArrayList regIdList = Lists.newArrayList((Object[])new String[]{userToken.getToken()});
            Result result = sender.send(messageBuilder.build(), (List)regIdList, 3);
            String parseResult = this.parseResult(result);
            if ("ok".equals(parseResult)) {
                callback.apply(message, userToken, Response.success());
            } else {
                this.logger.info("\u63a8\u9001\u5931\u8d25\uff0c\u91cd\u65b0\u63a8\u9001\u3002\u6d88\u606f:[{}],\u5931\u8d25\u539f\u56e0\uff1a[{}]", (Object)message, (Object)parseResult);
                callback.apply(message, userToken, Response.fail(parseResult));
            }
        }
        catch (IOException | ParseException e) {
            callback.apply(message, userToken, Response.fail(e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    private void fillMessageBuilder(Message.Builder messageBuilder, PushMessage message) {
        if (message.getActionType() != null) {
            String encodeMsg = "";
            try {
                encodeMsg = URLEncoder.encode(message.getPayloadInfo().toJsonString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            String intent = "intent:#Intent;component=com.bxm.localmastercard/.ui.push.PushRouteActivity;S.message=" + encodeMsg + ";end";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u63a8\u9001\u62a5\u6587:{}", (Object)intent);
            }
            messageBuilder.extra("intent_uri", intent);
        }
        if (TemplateTypeEnum.NOTIFCTION.equals((Object)message.getType())) {
            messageBuilder.passThrough(0);
        } else {
            messageBuilder.passThrough(1);
        }
        if (message.isMute()) {
            messageBuilder.notifyType(Integer.valueOf(0));
        } else if (message.isShock()) {
            messageBuilder.notifyType(Integer.valueOf(3));
        } else {
            messageBuilder.notifyType(Integer.valueOf(1));
        }
    }

    private String parseResult(Result result) {
        if (result.getErrorCode().getValue() == 0) {
            return "ok";
        }
        return result.getReason();
    }

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.MIUI;
    }
}

