/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.platform.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.platform.impl.AbstractPushPlatform;
import com.bxm.localnews.msg.platform.impl.umeng.AndroidNotification;
import com.bxm.localnews.msg.platform.impl.umeng.UmengNotification;
import com.bxm.localnews.msg.platform.impl.umeng.android.AndroidUnicast;
import com.bxm.localnews.msg.platform.impl.umeng.ios.AlertMsg;
import com.bxm.localnews.msg.platform.impl.umeng.ios.IOSUnicast;
import com.bxm.localnews.msg.push.PushResponseCallback;
import com.bxm.localnews.msg.push.Response;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class UmengPushPlatform
extends AbstractPushPlatform {
    private static final String HOST = "http://msg.umeng.com/api/send";
    @Resource
    private HttpClientService httpClientService;
    @Resource
    private AppPushProperties appPushProperties;

    @Override
    public PlatformTypeEnum getType() {
        return PlatformTypeEnum.UMENG;
    }

    @Override
    public void push(PushMessage message, MsgUserTokenBean userToken, PushResponseCallback callback) {
        this.logger.debug("\u6d88\u606f\u63a8\u9001\u7c7b\u578b\u4e3a\uff1a[{}]", (Object)message.getType());
        UmengNotification unicast = Objects.equals(PlatformEnum.IOS.getCode(), userToken.getPlatform()) ? this.createIOSUnicast(message, userToken) : this.createAndroidUnicast(message, userToken);
        if (null == unicast) {
            callback.apply(message, userToken, Response.fail("nullpoint"));
            return;
        }
        String postUrl = HOST;
        String postBody = unicast.getPostBody();
        String sign = "";
        this.logger.debug("\u63a8\u9001\u6d88\u606f\uff1a[{}]", (Object)postBody);
        try {
            sign = DigestUtils.md5Hex((byte[])("POST" + postUrl + postBody + unicast.getAppMasterSecret()).getBytes("utf8"));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        postUrl = postUrl + "?sign=" + sign;
        try {
            String response = this.httpClientService.doPost(postUrl, postBody);
            this.logger.debug("umeng push result:[{}]", (Object)response);
            if (null == response) {
                callback.apply(message, userToken, Response.fail("without response"));
                return;
            }
            String result = this.parseResult(response);
            if ("ok".equals(result)) {
                callback.apply(message, userToken, Response.success());
            } else {
                callback.apply(message, userToken, Response.fail(result));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            callback.apply(message, userToken, Response.fail(e.getMessage()));
        }
    }

    private String parseResult(String response) {
        JSONObject json = JSONObject.parseObject((String)response);
        String ret = json.getString("ret");
        if (StringUtils.equalsIgnoreCase((CharSequence)"SUCCESS", (CharSequence)ret)) {
            return "ok";
        }
        return response;
    }

    private IOSUnicast createIOSUnicast(PushMessage message, MsgUserTokenBean userToken) {
        try {
            IOSUnicast unicast = new IOSUnicast();
            unicast.setAppMasterSecret(this.appPushProperties.getUmengIosAppSecrect());
            unicast.setPredefinedKeyValue("appkey", this.appPushProperties.getUmengIosAppkey());
            String timestamp = Integer.toString((int)(System.currentTimeMillis() / 1000L));
            unicast.setPredefinedKeyValue("timestamp", timestamp);
            unicast.setDeviceToken(userToken.getToken());
            AlertMsg alertMsg = new AlertMsg(message.getTitle(), message.getContent());
            unicast.setAlert(JSONObject.toJSON((Object)alertMsg));
            unicast.setContentAvailable(0);
            unicast.setBadge(1);
            if (this.appPushProperties.isUmengProductionMode()) {
                unicast.setProductionMode();
            } else {
                unicast.setTestMode();
            }
            if (message.isMute()) {
                unicast.setSound(PushSoundEnum.IOS_MUTE.getIosSound());
            } else {
                unicast.setSound(message.getSound().getIosSound());
            }
            unicast.setCustomizedField("extend", JSONObject.toJSON((Object)message.getPayloadInfo().getExtend()));
            unicast.setCustomizedField("type", message.getPayloadInfo().getType());
            unicast.setCustomizedField("title", message.getTitle());
            unicast.setCustomizedField("content", message.getContent());
            unicast.setCustomizedField("msgId", message.getPayloadInfo().getMsgId());
            if (StringUtils.isNotBlank((CharSequence)message.getPayloadInfo().getProtocol())) {
                unicast.setCustomizedField("protocol", message.getPayloadInfo().getProtocol());
            }
            if (message.getPeriodTime() != null) {
                Date now = new Date();
                Date expireDate = DateUtils.addField((Date)now, (int)10, (int)message.getPeriodTime());
                unicast.setExpireTime(DateUtils.formatAtWill((Date)expireDate, (String)"yyyy-MM-dd HH:mm:ss"));
            }
            return unicast;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private AndroidUnicast createAndroidUnicast(PushMessage message, MsgUserTokenBean userToken) {
        try {
            AndroidUnicast unicast = new AndroidUnicast();
            unicast.setAppMasterSecret(this.appPushProperties.getUmengAndroidAppSecrect());
            unicast.setPredefinedKeyValue("appkey", this.appPushProperties.getUmengAndroidAppkey());
            String timestamp = Integer.toString((int)(System.currentTimeMillis() / 1000L));
            unicast.setPredefinedKeyValue("timestamp", timestamp);
            unicast.setDeviceToken(userToken.getToken());
            unicast.setBody(message.getTitle(), message.getTitle(), message.getContent());
            unicast.setPlay(message.isShock(), message.isMute());
            if (message.isMute()) {
                unicast.setSound(PushSoundEnum.IOS_MUTE.getAndriodSound());
            } else {
                unicast.setSound(message.getSound().getAndriodSound());
            }
            if (TemplateTypeEnum.TRANSMISSION.equals((Object)message.getType())) {
                unicast.setDisplayType(AndroidNotification.DisplayType.MESSAGE);
            } else {
                unicast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
            }
            unicast.setCustomField(JSONObject.parseObject((String)JSONObject.toJSONString((Object)message.getPayloadInfo())));
            unicast.goAppAfterOpen();
            if (this.appPushProperties.isUmengProductionMode()) {
                unicast.setProductionMode();
            } else {
                unicast.setTestMode();
            }
            unicast.setExtra(JSONObject.parseObject((String)JSON.toJSONString((Object)message.getPayloadInfo())));
            if (message.getPeriodTime() != null) {
                Date now = new Date();
                Date expireDate = DateUtils.addField((Date)now, (int)10, (int)message.getPeriodTime());
                unicast.setExpireTime(DateUtils.formatAtWill((Date)expireDate, (String)"yyyy-MM-dd HH:mm:ss"));
            }
            return unicast;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

