/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.push;

import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.platform.IPushPlatform;
import com.bxm.localnews.msg.push.impl.DefaultPushResponseCallback;
import com.bxm.localnews.msg.rule.IPushRule;
import com.bxm.localnews.msg.service.UserMessageService;
import com.bxm.localnews.msg.service.UserTokenService;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PushExecutor {
    private static final Logger log = LoggerFactory.getLogger(PushExecutor.class);
    private final List<IPushRule> rules;
    private final UserTokenService userTokenService;
    private final UserMessageService userMessageService;
    private Map<PlatformTypeEnum, IPushPlatform> platformMap;
    private final DefaultPushResponseCallback pushResponseCallback;
    private final AppPushProperties appPushProperties;
    private IPushPlatform defaultPlatform;

    @Autowired
    public PushExecutor(List<IPushRule> rules, UserTokenService userTokenService, UserMessageService userMessageService, List<IPushPlatform> platforms, DefaultPushResponseCallback pushResponseCallback, AppPushProperties appPushProperties) {
        this.rules = rules;
        this.userTokenService = userTokenService;
        this.userMessageService = userMessageService;
        this.pushResponseCallback = pushResponseCallback;
        this.appPushProperties = appPushProperties;
        this.platformMap = Maps.newHashMap();
        for (IPushPlatform platform : platforms) {
            this.platformMap.put(platform.getType(), platform);
        }
    }

    public void setDefaultPlatform(IPushPlatform defaultPlatform) {
        this.defaultPlatform = defaultPlatform;
    }

    public void push(PushMessage message) {
        boolean passRule = true;
        for (IPushRule rule : this.rules) {
            passRule = rule.accpect(message);
            if (passRule) continue;
            if (rule.write()) break;
            if (log.isDebugEnabled()) {
                log.debug("\u6d88\u606f\u53d1\u9001\u9a8c\u8bc1\u5931\u8d25\uff0c\u9a8c\u8bc1\u89c4\u5219\uff1a{},\u63a8\u9001\u5185\u5bb9\uff1a{}", rule.getClass(), (Object)message);
            }
            return;
        }
        Long userId = message.getPushReceiveScope().getUserId();
        this.saveMessage(message, userId);
        if (passRule) {
            try {
                List<MsgUserTokenBean> tokenList = this.userTokenService.loadToken(userId);
                boolean match = false;
                for (MsgUserTokenBean userTokenBean : tokenList) {
                    PlatformTypeEnum platform;
                    if (null == userTokenBean.getToken() || !(platform = PlatformTypeEnum.getByCode((byte)userTokenBean.getType())).isApp()) continue;
                    match = true;
                    this.fillMessage(message);
                    this.platformMap.get(platform).push(message, userTokenBean, this.pushResponseCallback);
                    break;
                }
                if (!match && this.defaultPlatform != null) {
                    MsgUserTokenBean token = new MsgUserTokenBean();
                    token.setUserId(userId);
                    this.defaultPlatform.push(message, token, this.pushResponseCallback);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void fillMessage(PushMessage message) {
        if (StringUtils.isEmpty((Object)message.getContent())) {
            message.setContent(this.appPushProperties.getDefaultPushContent());
        }
    }

    private void saveMessage(PushMessage message, Long userId) {
        if (message.isPersistence()) {
            this.userMessageService.addMessage(message, userId);
        }
    }
}

