/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.config.MessageTypeProperties;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.service.PushMessageDispatcher;
import com.bxm.localnews.msg.service.PushMsgSupplyService;
import com.bxm.localnews.msg.timer.PushMessageTask;
import com.bxm.localnews.msg.utils.IntervalPeriodUtils;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pushMsgSupplyService")
public class PushMsgSupplyServiceImpl
extends BaseService
implements PushMsgSupplyService {
    private static final Logger log = LoggerFactory.getLogger(PushMsgSupplyServiceImpl.class);
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private ScheduleService scheduleService;
    @Resource
    private PushMessageTask pushMessageTask;
    @Resource
    private MessageTypeProperties messageTypeProperties;
    @Resource
    private PushMessageDispatcher pushMessageDispatcher;

    @Override
    public void pushMsg(PushMessage message) {
        this.pushMessageDispatcher.push(message);
    }

    @Override
    public void pushInteraction() {
        KeyGenerator key;
        int index = IntervalPeriodUtils.getPreIntervalIndex();
        HashMap intervalNumMap = Maps.newHashMap();
        for (MessageTypeEnum messageType : this.messageTypeProperties.getInteractionType()) {
            key = RedisConfig.INTERACTION_NUM.copy().appendKey((Object)index).appendKey((Object)messageType.name());
            Map typeMap = this.redisHashMapAdapter.entries(key, Long.class);
            if (null == typeMap) continue;
            typeMap.forEach((userIdStr, num) -> intervalNumMap.merge(userIdStr, num, Long::sum));
        }
        if (intervalNumMap.isEmpty()) {
            log.info("{}\u6ca1\u6709\u53d1\u751f\u7528\u6237\u4e92\u52a8\u6d88\u606f", (Object)DateUtils.formatDateTime((Date)new Date()));
            return;
        }
        HashMap lastMsgMap = Maps.newHashMap();
        for (MessageTypeEnum messageType : this.messageTypeProperties.getInteractionType()) {
            key = RedisConfig.LAST_INTERACTION_MSG.copy().appendKey((Object)index).appendKey((Object)messageType.name());
            Map typeMap = this.redisHashMapAdapter.entries(key, PushMessage.class);
            if (null == typeMap) continue;
            lastMsgMap.putAll(typeMap);
        }
        intervalNumMap.forEach((userIdStr, num) -> {
            PushMessage message = (PushMessage)lastMsgMap.get(userIdStr);
            if (num == 0L || null == message) {
                log.info("\u672a\u8bfb\u6d88\u606f\u6570\u91cf\u4e3a0\uff0c\u6216\u6d88\u606f\u4e3anull.\u7528\u6237ID\uff1a[{}]", userIdStr);
            } else {
                Long userId = Long.valueOf(userIdStr);
                if (num == 1L) {
                    this.pushSingle(message, userId);
                } else {
                    this.pushSum(message, userId, (Long)num);
                }
            }
        });
    }

    private void pushSingle(PushMessage message, Long userId) {
        PushPayloadInfo payloadInfo = message.getPayloadInfo();
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setTitle(message.getTitle());
        if (StringUtils.isBlank((String)message.getContent())) {
            pushMessage.setContent(message.getTitle());
        } else {
            pushMessage.setContent(message.getContent());
        }
        pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
        pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        pushMessage.setPayloadInfo(payloadInfo);
        pushMessage.setPersistence(false);
        this.pushMsg(pushMessage);
    }

    private void pushSum(PushMessage message, Long userId, Long total) {
        PushPayloadInfo payloadInfo = message.getPayloadInfo();
        String name = payloadInfo.getExtend().get("nickname").toString();
        String title = name + " \u7b49\u7528\u6237\u8ddf\u4f60\u6709" + total + "\u6761\u4e92\u52a8\u6d88\u606f\u54e6\uff0c\u5feb\u6765\u770b\u770b\u5427";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.INTERACTION_MSG);
        info.setTitle(title);
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setTitle("\u6709\u4eba\u548c\u4f60\u6253\u62db\u547c\uff0c\u5feb\u6765\u770b\u770b\u5427");
        pushMessage.setContent(title);
        pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
        pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        pushMessage.setPayloadInfo(info);
        pushMessage.setPersistence(false);
        this.pushMsg(pushMessage);
    }
}

