/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.mq.common.model.dto.UserTokenParam;
import com.bxm.localnews.msg.constant.RedisConfig;
import com.bxm.localnews.msg.domain.MsgUserTokenMapper;
import com.bxm.localnews.msg.param.UserLogoutEvent;
import com.bxm.localnews.msg.service.UserTokenService;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Service;

@Service
public class UserTokenServiceImpl
implements UserTokenService {
    private static final Logger log = LoggerFactory.getLogger(UserTokenServiceImpl.class);
    private final MsgUserTokenMapper msgUserTokenMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final SequenceCreater sequenceCreater;
    private TypeReference<List<MsgUserTokenBean>> reference = new TypeReference<List<MsgUserTokenBean>>(){};
    private static final long EXPIRED_SECONDS = 259200L;

    @StreamListener(value="userLogoutInput")
    public void handlerLogout(UserLogoutEvent event) {
        if (null == event) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u6e05\u7406\u7528\u6237token\uff0c\u7528\u6237ID\uff1a{}", (Object)event.getUserId());
        }
        this.msgUserTokenMapper.deleteByUserId(event.getUserId());
        this.removeCache(event.getUserId());
    }

    @Autowired
    public UserTokenServiceImpl(MsgUserTokenMapper msgUserTokenMapper, RedisStringAdapter redisStringAdapter, SequenceCreater sequenceCreater) {
        this.msgUserTokenMapper = msgUserTokenMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.sequenceCreater = sequenceCreater;
    }

    private KeyGenerator buildKey(Long userId) {
        return RedisConfig.USER_TOKEN_CACHE.copy().appendKey((Object)userId);
    }

    @Override
    public List<MsgUserTokenBean> loadToken(Long userId) {
        KeyGenerator key = this.buildKey(userId);
        List entries = (List)this.redisStringAdapter.get(key, this.reference);
        if (null == entries) {
            List userTokenList = this.msgUserTokenMapper.queryUserToken(userId);
            if (CollectionUtils.isEmpty((Collection)userTokenList)) {
                entries = Lists.newArrayList();
                entries.add(new MsgUserTokenBean());
            } else {
                entries = userTokenList;
            }
            this.redisStringAdapter.set(key, (Object)entries, 259200L);
        }
        return entries;
    }

    private void removeCache(Long userId) {
        this.redisStringAdapter.remove(this.buildKey(userId));
    }

    @Override
    public void removeToken(MsgUserTokenBean tokenInfo) {
        if (null != tokenInfo.getUserId()) {
            this.msgUserTokenMapper.deleteByUserId(tokenInfo.getUserId());
            this.removeCache(tokenInfo.getUserId());
        }
    }

    @Override
    public void addToken(UserTokenParam param) {
        Preconditions.checkArgument((null != param && null != param.getUserId() ? 1 : 0) != 0);
        Preconditions.checkArgument((null != param.getTokenType() ? 1 : 0) != 0);
        this.msgUserTokenMapper.removeToken(param.getUserId(), Byte.valueOf(param.getTokenType().getCode()));
        MsgUserTokenBean token = new MsgUserTokenBean();
        token.setId(this.sequenceCreater.nextLongId());
        token.setCreateTime(new Date());
        token.setUserId(param.getUserId());
        token.setPlatform(Byte.valueOf((byte)param.getPlatform().getCode()));
        token.setToken(param.getToken());
        token.setType(Byte.valueOf(param.getTokenType().getCode()));
        this.msgUserTokenMapper.insert(token);
        this.removeCache(param.getUserId());
    }
}

