/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.strategy.impl;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.config.AppPushProperties;
import com.bxm.localnews.msg.config.PushMessageStatusEnum;
import com.bxm.localnews.msg.param.PushMessageBucket;
import com.bxm.localnews.msg.service.MessageGroupCounterService;
import com.bxm.localnews.msg.service.MessageGroupService;
import com.bxm.localnews.msg.strategy.IPushDistributeStrategy;
import com.bxm.localnews.msg.stream.MessageProvider;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPushDistributeStrategy
implements IPushDistributeStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractPushDistributeStrategy.class);
    private MessageGroupService messageGroupService;
    @Resource
    private MessageGroupCounterService messageGroupCounterService;
    @Resource
    protected AppPushProperties appPushProperties;
    @Resource
    protected MessageProvider messageProvider;

    protected MessageGroupService getMessageGroupService() {
        if (this.messageGroupService == null) {
            this.messageGroupService = (MessageGroupService)SpringContextHolder.getBean(MessageGroupService.class);
        }
        return this.messageGroupService;
    }

    void execPreprocess(PushMessage message) {
        this.messageGroupCounterService.saveCounter(message);
        this.getMessageGroupService().changeStatus(message.getMsgId(), PushMessageStatusEnum.BEING_SEND);
    }

    void splitTask(List<Long> userIds, Long msgId, int index, int total) {
        int bucketNum = this.appPushProperties.getBucketNum();
        int size = userIds.size();
        int splitNum = size / bucketNum + (size % bucketNum == 0 ? 0 : 1);
        for (int i = 0; i < splitNum; ++i) {
            int startIndex = i * bucketNum;
            int endIndex = startIndex + bucketNum;
            if (endIndex > size) {
                endIndex = size;
            }
            List<Long> subUserIds = userIds.subList(startIndex, endIndex);
            PushMessageBucket param = PushMessageBucket.builder().pushMsgId(msgId).targetUserIds(subUserIds).index(Integer.valueOf(index)).total(Integer.valueOf(total)).build();
            if (log.isDebugEnabled()) {
                log.debug("msgId:{},index:{},total:{}", new Object[]{msgId, index, total});
            }
            this.messageProvider.batchPush(param);
        }
        this.getMessageGroupService().addPushTotal(msgId, userIds.size());
    }
}

