package com.bxm.localnews.msg.config;

/**
 * 群推消息状态
 *
 * @author zhaoyadong 2019/1/17 10:13
 * @desc
 */
public enum PushMessageStatusEnum {
    /**
     * 编辑未确定
     */
    STAY_CONFIRM((byte) 0, "待确认"),
    /**
     * 定时推动，等待任务触发
     */
    STAY_SEND((byte) 1, "待发送"),
    /**
     * 已完成发送
     */
    HAS_BEEN_SEND((byte) 2, "已发送"),
    /**
     * 正在发送中
     */
    BEING_SEND((byte) 3, "推送中"),

    /**
     * 取消推送
     */
    CANCEL((byte) 4, "取消推送");

    private Byte type;

    private String desc;

    PushMessageStatusEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getPushMessageStatusEnumByType(Byte type) {
        for (PushMessageStatusEnum statusEnum : PushMessageStatusEnum.values()) {
            if (statusEnum.getType().equals(type)) {
                return statusEnum.getDesc();
            }
        }
        return null;
    }

    public static PushMessageStatusEnum getByStatus(Byte type) {
        for (PushMessageStatusEnum statusEnum : PushMessageStatusEnum.values()) {
            if (statusEnum.getType().equals(type)) {
                return statusEnum;
            }
        }
        return null;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
