package com.bxm.localnews.msg.rule.impl;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.rule.IPushRule;
import com.bxm.localnews.msg.service.MessageGroupService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.springframework.stereotype.Component;

/**
 * 推送黑名单验证规则
 * 取消推送时进行数据召回
 *
 * @author liujia
 * @date 2020-07-05 11:24
 **/
@Component
public class BlackMsgPushRule implements IPushRule {

    private MessageGroupService messageGroupService;

    private MessageGroupService getMessageGroupService() {
        if (messageGroupService == null) {
            messageGroupService = SpringContextHolder.getBean(MessageGroupService.class);
        }
        return messageGroupService;
    }

    @Override
    public boolean accpect(PushMessage message) {
        //判断推送的消息是否在召回的范围内，仅判断批量推送
        if (getMessageGroupService().isGroupMsg(message.getMsgId())) {
            return Boolean.FALSE.equals(getMessageGroupService().isBlackMsgId(message.getMsgId()));
        }
        return true;
    }
}
