package com.bxm.localnews.msg.service;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.vo.MsgGroupPushCounterBean;

import java.util.List;

/**
 * 群推消息统计相关接口
 *
 * @author liujia
 * @date 2020-07-04 17:01
 **/
public interface MessageGroupCounterService {

    /**
     * 创建推送相关的统计信息，后续用于数据汇总
     *
     * @param message 推送消息
     */
    void saveCounter(PushMessage message);

    /**
     * 增加统计数据，将数据推入队列，统一进行处理
     * 主要是运营后台的统计数据，允许进行一定的数据丢失
     *
     * @param counter 统计数据
     */
    void addCounter(MsgGroupPushCounterBean counter);

    /**
     * 查询消息的不同平台统计结果
     *
     * @param msgId 消息ID
     */
    List<MsgGroupPushCounterBean> getMessageCounter(Long msgId);
}
