package com.bxm.localnews.msg.service;

import com.bxm.localnews.mq.common.model.dto.UserTokenParam;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;

import java.util.List;

/**
 * 用户token相关服务接口
 * 用户的推送token、微信token等均可进行记录
 *
 * @author liujia
 * @date 2020-07-05 22:02
 **/
public interface UserTokenService {
    /**
     * 加载用户推送相关的token
     *
     * @param userId 用户ID
     * @return 推送相关的token
     */
    List<MsgUserTokenBean> loadToken(Long userId);

    /**
     * 移除用户的token信息
     *
     * @param tokenInfo token信息
     */
    void removeToken(MsgUserTokenBean tokenInfo);

    /**
     * 添加用户token信息
     * 删除用户对应的推送平台与参数，然后插入数据
     * 处理完成后删除用户缓存信息
     *
     * @param param token上报参数
     */
    void addToken(UserTokenParam param);
}
