package com.bxm.localnews.mq.consume.consumer.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.bxm.localnews.mq.common.constant.MQConstant;
import com.bxm.localnews.mq.consume.integration.NewsSyncFeignService;
import com.bxm.localnews.mq.consume.param.NewsStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

import static com.bxm.localnews.mq.common.constant.MQConstant.TAG.NEW_CLICK_KEY;

@Component
public class NewsClickConsumer extends AbstractNewsActionMessageConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsClickConsumer.class);

    @Autowired
    NewsSyncFeignService newsSyncFeignService;


    @Override
    public boolean support(String tag) {
        return NEW_CLICK_KEY.equals(tag);
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        try {
            this.newsClick(message);
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return Action.ReconsumeLater;
        }
        LOGGER.debug("消费成功，消息内容：" + message);
        return Action.CommitMessage;
    }

    private void newsClick(Message message) {
        JSONObject body = getMsgBody(message);
        //Long userId = Long.valueOf(body.getString(MQConstant.NEW_CLICK_KEY.USER_ID));
        Long newsId = Long.valueOf(body.getString(MQConstant.NEW_CLICK_KEY.NEWS_ID));

        NewsStatistics newsStatistics = new NewsStatistics();
        newsStatistics.setClicks(1);
        newsStatistics.setNewClicks(1);
        newsStatistics.setNewsId(newsId);

        List<NewsStatistics> newsStatisticsList = new ArrayList<>();
        newsStatisticsList.add(newsStatistics);

        newsSyncFeignService.updateStatistic(newsStatisticsList);
    }
}
