package com.bxm.localnews.mq.consume.consumer.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.bxm.localnews.mq.common.constant.MQConstant;
import com.bxm.localnews.mq.consume.integration.NewsSyncFeignService;
import com.bxm.localnews.mq.consume.param.NewsStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

import static com.bxm.localnews.mq.common.constant.MQConstant.TAG.COLLECT_KEY;

@Component
public class NewsCollectConsumer extends AbstractNewsActionMessageConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsCollectConsumer.class);

    @Autowired
    NewsSyncFeignService newsSyncFeignService;


    @Override
    public boolean support(String tag) {
        return COLLECT_KEY.equals(tag);
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        try {
            this.newsCollect(message);
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return Action.ReconsumeLater;
        }
        LOGGER.debug("消费成功，消息内容：" + message);
        return Action.CommitMessage;
    }

    private void newsCollect(Message message) {
        JSONObject body = getMsgBody(message);
        //Long userId = Long.valueOf(body.getString(MQConstant.NEW_CLICK_KEY.USER_ID));
        Long newsId = Long.valueOf(body.getString(MQConstant.NEW_CLICK_KEY.NEWS_ID));
        Byte type = Byte.valueOf(body.getString("type"));

        NewsStatistics newsStatistics = new NewsStatistics();
        if (type == 0) {
            newsStatistics.setCollects(-1);
        } else {
            newsStatistics.setCollects(1);
        }
        newsStatistics.setNewsId(newsId);

        List<NewsStatistics> newsStatisticsList = new ArrayList<>();
        newsStatisticsList.add(newsStatistics);

        newsSyncFeignService.updateStatistic(newsStatisticsList);
    }


}
