package com.bxm.localnews.mq.consume.consumer.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.bxm.localnews.mq.common.constant.MQConstant;
import com.bxm.localnews.mq.consume.integration.NewsFeignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static com.bxm.localnews.mq.common.constant.MQConstant.TAG.VIDEO_BLACK_KEY;
import static com.bxm.localnews.mq.common.constant.MQConstant.TAG.VIDEO_COMMENT_KEY;

@Component
public class VideoCommentConsumer extends AbstractNewsActionMessageConsumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(VideoCommentConsumer.class);

    @Autowired
    NewsFeignService newsFeignService;


    @Override
    public boolean support(String tag) {
        return VIDEO_COMMENT_KEY.equals(tag);
    }

    @Override
    public Action consume(Message message, ConsumeContext context) {
        try {
            this.newsViews(message);
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return Action.ReconsumeLater;
        }
        LOGGER.debug("小视频评论消费成功，消息内容：" + message);
        return Action.CommitMessage;
    }

    private void newsViews(Message message) {
        JSONObject body = getMsgBody(message);
        Long userId = Long.valueOf(body.getString(MQConstant.NEW_CLICK_KEY.USER_ID));
        Long newsId = Long.valueOf(body.getString(MQConstant.NEW_CLICK_KEY.NEWS_ID));

        newsFeignService.videoCommentConsume(userId,newsId);
    }

}
