package com.bxm.localnews.mq.consume.integration;

import com.bxm.localnews.mq.consume.integration.fallback.NewsSyncFallbackFactory;
import com.bxm.localnews.mq.consume.param.NewsRecommended;
import com.bxm.localnews.mq.consume.param.NewsStatistics;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "localnews-spider-sync", fallbackFactory = NewsSyncFallbackFactory.class)
public interface NewsSyncFeignService {

     @PostMapping(value = "api/news/sync/statistic")
     ResponseEntity updateStatistic(@RequestBody List<NewsStatistics> newsStatisticsList);

     @PostMapping(value = "api/news/sync/recommended")
     ResponseEntity saveRecommended(@RequestBody List<NewsRecommended> newsRecommendedList);
}

