package com.bxm.localnews.mq.consume.push.receive;

import java.util.Map;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.consume.push.receive.impl.*;
import com.bxm.localnews.msg.domain.UserDeviceMapper;
import com.google.common.collect.Maps;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

/**
 * 构建用户获取迭代器对象
 */
@Component
public class ReceiveUserFactory {

    private final UserDeviceMapper userDeviceMapper;

    private ApplicationContext applicationContext;

    private Map<PushReceiverRuleEnum, IReceiveUserIterator> iteratorMap;

    @Autowired
    public ReceiveUserFactory(UserDeviceMapper userDeviceMapper) {
        this.userDeviceMapper = userDeviceMapper;
    }

    public IReceiveUserIterator get(PushReceiverRuleEnum rule, Map<String, Object> paramMap) {
        IReceiveUserIterator iterator;
        switch (rule){
            case AREA:
                iterator = new AreaReceiveUserIterator();
                break;
            case ALL:
                iterator = new AllReceiveUserIterator();
                break;
            case VIP_AREA:
                iterator = new AreaVipReceiveUserIterator();
                break;
            case VIP_USER:
                iterator = new UserVipReceiveUserIterator();
                break;
            default:iterator = new DefaultUserReceiveUserIterator();
        }
        return iterator.build(paramMap).setUserDeviceMapper(userDeviceMapper);
    }
}
