package com.bxm.localnews.mq.consume.push.receive.impl;

import com.bxm.localnews.mq.common.constant.ReceiverRuleParamConstant;
import com.bxm.localnews.mq.consume.push.receive.IReceiveUserIterator;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Map;

/**
 * 根据地区编码获取对应的用户信息
 * @author liujia
 */
public class AreaReceiveUserIterator extends AbstractReceiveUserIterator {

    private List<String> getAreaCodes() {
        List<String> param = getParam(ReceiverRuleParamConstant.AREA_CODES);
        if (null == param) {
            return Lists.newArrayList();
        }
        return param;
    }

    @Override
    int getTotal() {
        return userDeviceMapper.getAreaUserTotal(getAreaCodes());
    }

    @Override
    List<UserDeviceBean> queryByPage(int pageNum) {
        return userDeviceMapper.getAreaUserList(getAreaCodes(), pageNum * pageSize, pageSize);
    }

    @Override
    public IReceiveUserIterator build(Map<String, Object> paramMap) {
        AreaReceiveUserIterator iterator = new AreaReceiveUserIterator();
        iterator.paramMap = paramMap;
        return iterator;
    }
}
