package com.bxm.localnews.mq.consume.push.receive.impl;

import com.bxm.localnews.mq.common.constant.ActionTypeEnum;
import com.bxm.localnews.mq.common.constant.ReceiverRuleParamConstant;
import com.bxm.localnews.mq.consume.push.receive.IReceiveUserIterator;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 根据地区编码获取对应的用户信息
 * @author liujia
 */
public class AreaVipReceiveUserIterator extends AbstractReceiveUserIterator {

    private List<String> getAreaCodes() {
        List<String> param = getParam(ReceiverRuleParamConstant.AREA_CODES);
        if (null == param) {
            return Lists.newArrayList();
        }
        return param;
    }

    /**
     * 是否包含成功绑定好友关系
     */
    private Byte getRecord() {
        Byte status = getVipStatus();
        Byte record = null;
        if (ActionTypeEnum.VIP_NOT_ACTIVATION.getType().equals(status)) {
            record = 0;
        } else if (ActionTypeEnum.VIP_CONTINUE_ACTIVATION.getType().equals(status)) {
            record = 1;
        }

        return record;
    }

    private Byte getVipStatus() {
        Object obj = getParam(ReceiverRuleParamConstant.VIP);
        return Byte.valueOf(Objects.toString(obj, "0"));
    }

    /**
     * vip状态
     */
    private Byte getStatus() {
        Byte status = getVipStatus();
        if (ActionTypeEnum.VIP_ACTIVATION.getType().equals(status)) {
            status = 2;
        } else {
            status = 1;
        }
        return status;
    }

    @Override
    int getTotal() {
        return userDeviceMapper.getAreaVipUserTotal(getAreaCodes(), getStatus(), getRecord());
    }

    @Override
    List<UserDeviceBean> queryByPage(int pageNum) {
        return userDeviceMapper.getAreaVipUserList(getAreaCodes(), pageNum * pageSize, pageSize, getStatus(), getRecord());
    }

    @Override
    public IReceiveUserIterator build(Map<String, Object> paramMap) {
        AreaVipReceiveUserIterator iterator = new AreaVipReceiveUserIterator();
        iterator.paramMap = paramMap;
        return iterator;
    }
}
