package com.bxm.localnews.mq.consume.push.receive.impl;

import com.bxm.localnews.mq.common.constant.ActionTypeEnum;
import com.bxm.localnews.mq.common.constant.ReceiverRuleParamConstant;
import com.bxm.localnews.mq.consume.push.receive.IReceiveUserIterator;
import com.bxm.localnews.msg.vo.UserDeviceBean;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author zhaoyadong 2019/2/20 10:01
 * @desc
 */
public class UserVipReceiveUserIterator extends AbstractReceiveUserIterator {

    private List<String> getUserIds() {
        List<String> param = getParam(ReceiverRuleParamConstant.USER_IDS);
        if (null == param) {
            return Lists.newArrayList();
        }
        return param;
    }

    /**
     * vip状态
     */
    private Byte getStatus() {
        Byte status = getVipStatus();
        if (ActionTypeEnum.VIP_ACTIVATION.getType().equals(status)) {
            status = 2;
        } else {
            status = 1;
        }
        return status;
    }

    private Byte getVipStatus() {
        Object obj = getParam(ReceiverRuleParamConstant.VIP);
        return Byte.valueOf(Objects.toString(obj, "0"));
    }

    @Override
    int getTotal() {
        return userDeviceMapper.getUserVipUserTotal(getUserIds(), getStatus());
    }

    @Override
    List<UserDeviceBean> queryByPage(int pageNum) {
        return userDeviceMapper.getUserVipUserList(getUserIds(), getStatus(), pageNum * pageSize, pageSize);
    }

    @Override
    public IReceiveUserIterator build(Map<String, Object> paramMap) {
        UserVipReceiveUserIterator iterator = new UserVipReceiveUserIterator();
        iterator.paramMap = paramMap;
        return iterator;
    }
}
