package com.bxm.localnews.mq.handle;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.constant.AppConst;
import com.bxm.localnews.mq.config.MessageProperties;
import com.bxm.localnews.mq.config.SmsOperatorConfig;
import com.bxm.localnews.mq.consume.service.SmsFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Slf4j
public class SmsMessageHandle {

    private final SmsOperatorConfig smsOperatorConfig;

    private final MessageProperties messageProperties;

    @Autowired
    public SmsMessageHandle(SmsOperatorConfig smsOperatorConfig, MessageProperties messageProperties) {
        this.smsOperatorConfig = smsOperatorConfig;
        this.messageProperties = messageProperties;
    }

    @Async
    public void send(Map<String, String> smsMap) {
        if (!messageProperties.getEnableSms()) {
            log.debug("短信未开启");
            log.debug(JSON.toJSONString(smsMap));
        }

        try {
            if ("shiyuan".equals(smsOperatorConfig.getOperator())) {
                String[] result = SmsFactory.send(AppConst.Sms.SHIYUAN, smsMap.get("phoneNo"), smsMap.get("content"));
                if (!"1".equals(result[0])) {
                    log.error("短信消费失败，尝试使用其他短信通道:" + result[0] + ":" + result[1], smsMap.get("phoneNo") + ":" + smsMap.get("content"));
                    chuanglanSms(smsMap);
                }
            } else {
                //创蓝作为备用方案
                chuanglanSms(smsMap);
            }
        } catch (Exception e) {
            //消费失败
            log.error("短信消费失败:" + e.getMessage(), e);
        }
    }

    private void chuanglanSms(Map<String, String> smsMap) {
        String[] result = SmsFactory.send(AppConst.Sms.CHUANGLAN, smsMap.get("phoneNo"), smsMap.get("content"));
        if (!"0".equals(result[0])) {
            log.error("短信消费失败:" + result[0] + ":" + result[1], smsMap.get("phoneNo") + ":" + smsMap.get("content"));
        } else {
            log.debug("短信消费成功", result[0] + "," + result[1]);
        }
    }
}
