package com.bxm.localnews.mq.produce.service.impl;

import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.mq.produce.service.AliMqService;
import com.bxm.localnews.mq.produce.service.PushMsgSupplyService;
import com.bxm.localnews.mq.utils.IntervalPeriodUtils;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;

import static com.bxm.localnews.mq.common.RedisConfig.INTERACTION_NUM;
import static com.bxm.localnews.mq.common.RedisConfig.LAST_INTERACTION_MSG;

/**
 * Created by Arei on 2018/10/12.
 */
@Service("pushMsgSupplyService")
@Slf4j
public class PushMsgSupplyServiceImpl extends BaseService implements PushMsgSupplyService {
    @Resource
    private AliMqService aliMqService;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public void pushMsg(PushMessage message) {
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.PUSH, message));
    }

    @Override
    public void pushInteraction() {
        int index = IntervalPeriodUtils.getPreIntervalIndex();
        KeyGenerator key = LAST_INTERACTION_MSG.copy().appendKey(index);
        Map<String, PushMessage> lastMsgMap = redisHashMapAdapter.entries(key, PushMessage.class);

        key = INTERACTION_NUM.copy().appendKey(index);
        Map<String, Long> intervalNumMap = redisHashMapAdapter.entries(key, Long.class);

        if (intervalNumMap == null || intervalNumMap.isEmpty()) {
            log.info("{}没有发生用户互动消息", DateUtils.formatDate(new Date()));
            return;
        }

        intervalNumMap.forEach((userIdStr, num) -> {
            PushMessage message = lastMsgMap.get(userIdStr);
            Long userId = Long.valueOf(userIdStr);
            if (num == 1) {
                pushSingle(message, userId);
            } else {
                pushSum(message, userId, num);
            }
        });
    }

    /**
     * 用户仅有一条互动消息时
     * @param message 互动消息
     * @param userId  对应用户
     */
    private void pushSingle(PushMessage message, Long userId) {
        PushPayloadInfo payloadInfo = message.getPayloadInfo();

        PushMessage pushMessage = PushMessage.build();
        pushMessage.setTitle(message.getTitle());
        pushMessage.setContent(message.getContent());
        pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
        pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        pushMessage.setPayloadInfo(payloadInfo);
        pushMessage.setPersistence(false);

        pushMsg(pushMessage);
    }

    /**
     * 用户有多条互动消息时，进行消息合并
     * @param message 最后一条互动消息
     * @param userId  对应用户
     * @param total   互动消息总数
     */
    private void pushSum(PushMessage message, Long userId, Long total) {
        Long msgId = nextId();
        PushPayloadInfo payloadInfo = message.getPayloadInfo();
        String name = payloadInfo.getExtend().get("nickname").toString();
        String title = name + " 等用户跟你有" + total + "条互动消息哦，快来看看吧";

        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.INTERACTION_MSG);
        info.setMsgId(msgId);
        info.addExtend("msgId", msgId);

        PushMessage pushMessage = PushMessage.build();
        pushMessage.setTitle("");
        pushMessage.setContent(title);
        pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
        pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        pushMessage.setPayloadInfo(info);
        //2.5.0 合并推送不显示在消息中心
        pushMessage.setPersistence(false);

        pushMsg(pushMessage);
    }
}
