package com.bxm.localnews.mq.produce.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.constant.AliMqMsgTagEnum;
import com.bxm.localnews.mq.common.constant.MQConstant;
import com.bxm.localnews.mq.produce.service.AliMqService;
import com.bxm.localnews.mq.produce.service.VideoStatisticService;
import com.bxm.localnews.msg.param.VideoBlackParam;
import com.bxm.localnews.msg.param.VideoShareParam;
import com.bxm.localnews.msg.param.VideoViewParam;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class VideoStatisticServiceImpl implements VideoStatisticService {

    private static final Logger logger = LoggerFactory.getLogger(VideoStatisticServiceImpl.class);

    private final AliMqService aliMqService;

    @Autowired
    public VideoStatisticServiceImpl(AliMqService aliMqService) {
        this.aliMqService = aliMqService;
    }

    @Override
    public void pushVideoBlackData(VideoBlackParam videoBlackParam) {
        logger.debug("屏蔽小视频数据上报,参数:{}", JSONObject.toJSONString(videoBlackParam));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.VIDEO_BLACK, videoBlackParam));
    }

    @Override
    public void pushShareData(VideoShareParam videoShareParam) {
        logger.debug("分享小视频数据上报,参数:{}", JSONObject.toJSONString(videoShareParam));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.VIDEO_SHARE, videoShareParam));
    }

    @Override
    public void pushViewData(VideoViewParam videoViewParam) {
        logger.debug("浏览小视频数据上报,参数:{}", JSONObject.toJSONString(videoViewParam));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.VIDEO_VIEW, videoViewParam));
    }

    @Override
    public void pushCommentData(Long userId, Long videoId) {
        Map<String, Object> shareMap = Maps.newHashMap();
        shareMap.put(MQConstant.NEW_CLICK_KEY.NEWS_ID, videoId);
        shareMap.put(MQConstant.NEW_CLICK_KEY.USER_ID, userId);
        logger.debug("评论小视频数据上报,参数:{}", JSONObject.toJSONString(shareMap));
        aliMqService.send(aliMqService.createMessage(AliMqMsgTagEnum.VIDEO_COMMENT, shareMap));
    }
}
